﻿<%@ Page language="c#" codePage="1200" AutoEventWireup="false" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Samochodowka" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Ewidencja przebiegu pojazdu</title>
		<script runat="server">
    void OnContextLoad(Object sender, EventArgs args)
    {
        ReportHeader1.Title =
			string.Format(
                ReportHeader1.Title, 
                param.Pojazd.NrRejestracyjny, 
                param.Okres,
                CaptionAttribute.EnumToString(param.Pojazd.Typ),
                param.Pojazd.Dysponent, param.Pojazd.DysponentAdres);

        Grid1.DataSource = new SubTable(
			SamochodowkaModule.GetInstance(param).Przejazdy.WgPojazd[param.Pojazd],
			param.Okres);
    }		        
		
	Params param;
	[Context]    
    public Params Param
    {
        set { param = value; }
    }

    public class Params : ContextBase
    {
        public Params(Context cx)
            : base(cx)
        {
        }

        Pojazd pojazd = null;
        [Context(typeof(Przejazdy.Params),"Pojazd")]
        [Priority(0)]
		[Required]
        public Pojazd Pojazd
        {
            get { return pojazd; }
            set { pojazd = value; }
        }

        FromTo okres;
        
        [Context(typeof(Przejazdy.Params), "Okres")]
        [Priority(1)]        
        public FromTo Okres
        {
            get { return okres; }
            set
			 {
				if(value==FromTo.Empty)
				value = FromTo.All;
			  okres = value; 
			  OnChanged(EventArgs.Empty);
			  }
        }        
    }        
		</script>
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="EwidencjaPrzebieguPojazdu" method="post" runat="server">
			<P><ea:datacontext id="DataContext1" runat="server" TypeName="Soneta.Business.Row[], Soneta.Business"
					oncontextload="OnContextLoad"></ea:datacontext>
				<cc1:ReportHeader id="ReportHeader1" title="Ewidencja przebiegu pojazdu {0}|Okres: {1}|Typ: {2}|Dysponent: {3}|Adres: {4}"
					runat="server"></cc1:ReportHeader><BR>
				<ea:grid id="Grid1" runat="server" RowTypeName="Soneta.Samochodowka.Przejazd,Soneta.Ksiega"
					RowsInRow="2" ShowPrevAgrSum="InFooter" ShowAgrSum="True" ShowPageSum="True">
					<Columns>
						<ea:GridColumn Width="6" Align="Center" DataMember="#" Caption="Lp." ID="colLp" RowSpan="2"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Center" DataMember="Data" Caption="Data" ID="colData" RowSpan="2"></ea:GridColumn>
						<ea:GridColumn DataMember="Trasa.Opis" Total="Info" Caption="Opis trasy" ID="colOpis"></ea:GridColumn>
						<ea:GridColumn DataMember="Trasa.Cel" Caption="Cel wyjazdu" ID="colCel"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Trasa.Dlugosc" Total="Sum" Caption="Długość"
							Format="{0:n}" ID="colDlugosc" RowSpan="2"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Right" DataMember="Stawka" Caption="Stawka za km" ID="colStawka"
							RowSpan="2"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Wartosc" Total="Sum" Caption="Wartość" Format="{0:n}"
							ID="colWartosc" RowSpan="2"></ea:GridColumn>
					</Columns>
				</ea:grid>
				<cc1:ReportFooter id="ReportFooter1" runat="server">
					<Subtitles>
						<cc1:FooterSubtitle SubtitleType="Operator"></cc1:FooterSubtitle>
					</Subtitles>
				</cc1:ReportFooter></P>
		</form>
	</body>
</HTML>

